from models.moneyrequest import MoneyRequest
from models.plaintext import Plaintext
from models.user import User
from utils.pswdgen import generateSecretFor
import os

def prepareInit():
    whatToInit = list()

    whatToInit.append(User(username='admin', password=os.environ['ADMINPASSWD'], balance=1000000000))
    whatToInit.append(User(username='johnfromaccounting', password=generateSecretFor("John"), balance=500))

    whatToInit.append(Plaintext(title='A piece of wisdom', description='We will generate a special piece of wisdom using military grade artificial intelligence just for you', plaintext="Don't do drugs", cost=10))
    whatToInit.append(Plaintext(title='A compliment', description='Did anyone tell you a compliment today? It\'s our job then!', plaintext="You look pretty today! Like, for real! Look at you!", cost=20))
    whatToInit.append(Plaintext(title='Financial advice', description='Need help getting back on your feet? Let us help you!', plaintext="Well, it looks like you've just spent all your money on the advice, so... that's not a good start. But come again next Tuesday and we will get into it", cost=100))
    whatToInit.append(Plaintext(title='A flag', description='Just a regular flag, I don\'t know why people want it so much lately... But I must admit it has a nice ECSC{...} format, I\'ll let them have that', plaintext="ECSC{REDACTED}", cost=100000000))
    
    return whatToInit
